%     NIT     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO WRITE NIT FILE FROM SYSTEM STRUCTURE
% ======================================================
%   USAGE :
%         1. out = wrnit(pso, fileName)
%         2. out = wrnit(pso)
%         3. out = wrnit
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function out = wrnit(pso, fileName)
if nargin < 1
    out = error('No NIT Structure is supplied');
elseif nargin < 2
    [fileName, pathName] = uiputfile( ...
        {'*.PSO;*.GA;*.ACO;*.BBO','NIT Files (*.PSO,*.GA,*.ACO,*.BBO)';
        '*.PSO', 'Particle Swarm Optimization files (*.PSO)'; ...
        '*.GA','Genetic Algorithms file (*.GA)'; ...
        '*.ACO','Ant Colony Optimization files (*.ACO)'; ...
        '*.BBO','Biogeoraphical Based Optimization (*.BBO)'}, ...
        'Save File Name');
end
[pathName fileName eXtn vwr] = fileparts(deblank(fileName));
fileName = [fileName '.' pso.Type ];

fid = fopen([pathName fileName], 'w');
if fid==-1
    out = error('Unable to write System Struture to File')
end

fprintf(fid, '[NI SYSTEM]\n\n');
fprintf(fid, 'nit.Name = ''%s''\n', fileName);
fprintf(fid, 'nit.Type = ''%s''\n\n', pso.Type);

fprintf(fid, '[PARTICLE STRING ENCODING]\n');
fprintf(fid, 'nit.String.File = ''%s''\n', pso.String.File);
fprintf(fid, 'nit.String.Sheet = ''%s''\n', pso.String.Sheet);
fprintf(fid, 'nit.String.Range = ''%s''\n\n', pso.String.Range);

fprintf(fid, '[STRING ENCODING CHECKS]\n');
fprintf(fid, 'nit.Checks.File = ''%s''\n', pso.Checks.File);
fprintf(fid, 'nit.Checks.Sheet = ''%s''\n', pso.Checks.Sheet);
fprintf(fid, 'nit.Checks.Range = ''%s''\n\n', pso.Checks.Range);

fprintf(fid, '[SWARM DESCRIPTION]\n');
fprintf(fid, 'nit.Swarm.PSize = %s\n', num2str(pso.Swarm.PSize));
fprintf(fid, 'nit.Swarm.Model = ''%s''\n', pso.Swarm.Model);
fprintf(fid, 'nit.Swarm.NSize = %1.0f\n', pso.Swarm.NSize);
fprintf(fid, 'nit.Swarm.Topology = ''%s''\n\n', pso.Swarm.Topology);

fprintf(fid, '[OBJECTIVE DESCRIPTION]\n');
fprintf(fid, 'nit.Objective.File = ''%s''\n', pso.Objective.File);
fprintf(fid, 'nit.Objective.Sheet = ''%s''\n', pso.Objective.Sheet);
fprintf(fid, 'nit.Objective.Range = ''%s''\n', pso.Objective.Range);
fprintf(fid, 'nit.Objective.Function = ''%s''\n\n', pso.Objective.Function);

fprintf(fid, '[STRATEGIC PARAMETERS]\n');
fprintf(fid, 'nit.Parameter.C1 = %s\n', num2str(pso.Parameter.C1));
fprintf(fid, 'nit.Parameter.C2 = %s\n', num2str(pso.Parameter.C2));
fprintf(fid, 'nit.Parameter.C3 = %s\n', num2str(pso.Parameter.C3));
fprintf(fid, 'nit.Parameter.MaxVelocity = %s\n', num2str(pso.Parameter.MaxVelocity));
fprintf(fid, 'nit.Parameter.Chi = %s\n', num2str(pso.Parameter.Chi));
fprintf(fid, 'nit.Parameter.WeightOption = ''%s''\n', pso.Parameter.WeightOption);
fprintf(fid, 'nit.Parameter.StartWeight = %s\n', num2str(pso.Parameter.StartWeight));
fprintf(fid, 'nit.Parameter.EndWeight = %s\n\n', num2str(pso.Parameter.EndWeight));

fprintf(fid, '[TERMINATION CRITERIA]\n');
fprintf(fid, 'nit.Terminate.NoChange = %s\n', num2str(pso.Terminate.NoChange));
fprintf(fid, 'nit.Terminate.Goal = %s\n', num2str(pso.Terminate.Goal));
fprintf(fid, 'nit.Terminate.MaxIterations = %s\n\n', num2str(pso.Terminate.MaxIterations));

fprintf(fid, '[PLOT OPTIONS]\n');
fprintf(fid, 'nit.Plot.GBest = %s\n', num2str(pso.Plot.GBest));
fprintf(fid, 'nit.Plot.Average = %s\n', num2str(pso.Plot.Average));
fprintf(fid, 'nit.Plot.LBest = %s\n', num2str(pso.Plot.LBest));

nit.Name = fileName;
out = nit;
fclose(fid);